<?php
/**
 * File 2020_07_09_111736_update_department_email_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\Ticket;

use App\Modules\Ticket\Models\DepartmentEmail;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

/**
 * Class UpdateDepartmentEmailTable
 */
class UpdateDepartmentEmailTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->string('auth_mech')
                ->default(DepartmentEmail::AUTH_PASSWORD)
                ->after('username')
                ->nullable();

            $table->text('oauth')->nullable()->after('password');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('department_email', function (Blueprint $table) {
            $table->dropColumn('auth_mech', 'oauth');
        });
    }
}
