<?php
/**
 * File 2020_09_07_160000_update_user_social_provider_table.php
 *
 * @copyright  Copyright (c) 2015-2020 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 */
namespace Database\Migrations\v3_3_0\User;

use App\Modules\Core\Controllers\Addons\Drivers\IntegrationDriver;
use App\Modules\Core\Models\Integration;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

/**
 * Class UpdateUserSocialProviderTable
 */
class UpdateUserSocialProviderTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        $driver = app(IntegrationDriver::class);

        // Synchronise integrations.
        $driver->synchronise();

        // Fetch integrations.
        $integrations = $driver->discover();

        $time = time();
        $providers = DB::table('user_social_provider')->get();

        foreach ($providers as $provider) {
            $integration = DB::table('integration')->where('name', $provider->name)->first();

            if (! empty($integration)) {
                if ($provider->enabled && ! $integration->enabled) {
                    // Activate integration is not already enabled.
                    $driver->activate($integrations->get($integration->name));
                }

                // Insert settings.
                if (! empty($provider->client_id)) {
                    DB::table('integration_setting')->insert([
                        'integration_id' => $integration->id,
                        'brand_id'       => $provider->brand_id,
                        'name'           => 'client_id',
                        'value'          => $provider->client_id,
                        'created_at'     => $time,
                        'updated_at'     => $time,
                    ]);
                }
                if (! empty($provider->client_secret)) {
                    DB::table('integration_setting')->insert([
                        'integration_id' => $integration->id,
                        'brand_id'       => $provider->brand_id,
                        'name'           => 'client_secret',
                        'value'          => $provider->client_secret,
                        'created_at'     => $time,
                        'updated_at'     => $time,
                    ]);
                }
            }
        }

        // Clear integration cache.
        Integration::setCache(null, true);

        // Drop columns.
        Schema::table('user_social_provider', function (Blueprint $table) {
            $table->dropColumn(['client_id', 'client_secret']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('user_social_provider', function (Blueprint $table) {
            $table->string('client_id', 255)->after('enabled');
            $table->string('client_secret', 255)->after('client_id');
        });
    }
}
