<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateScheduledTaskTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('scheduled_task_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('scheduled_task_id')->unsigned();
            $table->foreign('scheduled_task_id')->references('id')->on('scheduled_task')->onDelete('cascade');

            $table->string('name');
            $table->string('description')->nullable();

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'scheduled_task_id', 'locale' ]);
        });
    }
}
