<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateModuleTranslationTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('module_translation', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('module_id')->unsigned();
            $table->foreign('module_id')->references('id')->on('module')->onDelete('cascade');

            $table->string('name', 45);

            $table->string('locale', 5);
            $table->foreign('locale')->references('code')->on('language')->onDelete('cascade');

            $table->unique([ 'module_id', 'locale' ]);
        });
    }
}
