<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

use function json_decode;
use function json_encode;

class UpdateDepartmentTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Remove user_ticket_locked template from department settings.
        foreach (DB::table('department')->get() as $department) {
            if (empty($department->email_templates)) {
                continue;
            }

            $templates = json_decode($department->email_templates, true);
            unset($templates['user_ticket_locked']);

            DB::table('department')
                ->where('id', $department->id)
                ->update([ 'email_templates' => json_encode($templates) ]);
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        //
    }
}
