<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

class UpdateDepartmentOperatorMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('department_operator_membership', function (Blueprint $table) {
           $table->dropColumn('id');
        });

        $this->deleteDuplicates('department_operator_membership', 'department_id', 'user_id');

        Schema::table('department_operator_membership', function (Blueprint $table) {
            $table->unique(['department_id', 'user_id']);
        });
    }
}
