<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\Ticket;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

class UpdateSlaScheduleMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('sla_schedule_membership', function (Blueprint $table) {
            $table->dropColumn('id');
        });

        $this->deleteDuplicates('sla_schedule_membership', 'plan_id', 'schedule_id');

        Schema::table('sla_schedule_membership', function (Blueprint $table) {
            $table->unique(['plan_id', 'schedule_id']);
        });
    }
}
