<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Schema;

class UpdateOperatingSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Allow null value for column.
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->integer('default_ticket_filter')
                ->unsigned()
                ->nullable()
                ->default(null)
                ->change();
        });

        // Update all invalid (does not exist or zero) values to null.
        DB::table('operator_setting')
            ->leftJoin('ticket_filter', 'ticket_filter.id', '=', 'operator_setting.default_ticket_filter')
            ->where('default_ticket_filter', 0)
            ->orWhereNull('ticket_filter.id')
            ->update(['default_ticket_filter' => null]);

        // Add foreign key for column.
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->foreign('default_ticket_filter')
                ->references('id')
                ->on('ticket_filter')
                ->onDelete('set null');
        });
    }
}
