<?php declare(strict_types=1);

namespace Database\Migrations\v3_4_0\User;

use App\Modules\Core\Controllers\Database\Migration\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

class UpdateGroupRoleMembershipTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('group_role_membership', function (Blueprint $table) {
            $table->dropColumn('id');
        });

        $this->deleteDuplicates('group_role_membership', 'group_id', 'role_id');

        Schema::table('group_role_membership', function (Blueprint $table) {
            $table->unique(['group_id', 'role_id']);
        });
    }
}
