<?php declare(strict_types=1);

namespace Database\Migrations\v3_6_0\User;

use DB;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUserSessionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user_session', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->unsignedInteger('user_id');
            $table->foreign('user_id')->references('id')->on('user')->onDelete('cascade');

            $table->string('session_id', 100);
            $table->string('remember_token', 100)->nullable();

            $table->text('user_agent')->nullable();

            $table->unsignedInteger('created_at');
            $table->unsignedInteger('updated_at');

            $table->unique(['user_id', 'session_id']);
        });

        DB::statement('ALTER TABLE `user_session` ADD `ip` VARBINARY(16) AFTER `remember_token`;');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user_session');
    }
}
