<?php declare(strict_types=1);

namespace Database\Migrations\v4_0_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UpdateLanguageTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('language', function (Blueprint $table) {
            $table->tinyInteger('upgrade_available')->default(0)->after('enabled');
            $table->string('version')->nullable()->after('upgrade_available');
        });

        // Bug in Doctrine so have to do a manual statement.
        DB::statement('ALTER TABLE language CHANGE COLUMN enabled enabled TINYINT(4) NOT NULL DEFAULT \'0\'');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('language', function (Blueprint $table) {
            $table->dropColumn(['id', 'upgrade_available', 'version']);
        });

        // Bug in Doctrine so have to do a manual statement.
        DB::statement('ALTER TABLE language CHANGE COLUMN enabled enabled TINYINT(4) NOT NULL DEFAULT \'1\'');
    }
}
