<?php declare(strict_types=1);

namespace Database\Migrations\v4_0_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateTicketChannelTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('ticket_channel', function (Blueprint $table) {
            $table->tinyInteger('show_on_frontend')->default(0)->after('version');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('ticket_channel', function (Blueprint $table) {
            $table->dropColumn('show_on_frontend');
        });
    }
}
