<?php declare(strict_types=1);

namespace Database\Migrations\v4_0_0\Ticket;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Schema;

class CreateTicketUserPhoneNumber extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('ticket_user_phone_number', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('ticket_id')->unsigned();
            $table->foreign('ticket_id')->references('id')->on('ticket')->onDelete('cascade');

            $table->integer('number_id')->unsigned();
            $table->foreign('number_id')->references('id')->on('user_phone_number')->onDelete('cascade');

            $table->string('mode', 45);

            $table->unique(['ticket_id', 'number_id']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('ticket_user_phone_number');
    }
}
