<?php declare(strict_types=1);

namespace Database\Migrations\v4_0_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class UpdatePermissionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::table('permission')
            ->where('description', 'LIKE', '%::%')
            ->update(['description' => DB::raw('CONCAT("Plugins#", `description`)')]);

        DB::table('permission')
            ->where('name', 'LIKE', 'plugin')
            ->update(['name' => 'addon', 'description' => 'addon']);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::table('permission')
            ->where('description', 'LIKE', '%::%')
            ->update(['description' => DB::raw('REPLACE(`description` , "Plugins#", "")')]);

        DB::table('permission')
            ->where('name', 'LIKE', 'addon')
            ->update(['name' => 'plugin', 'description' => 'plugin']);
    }
}
