<?php declare(strict_types=1);

namespace Database\Migrations\v4_0_4\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class DeleteMarketplaceAddonTable extends Migration
{
    private string $table = 'marketplace_addon';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::drop($this->table);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::create($this->table, function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->increments('id')->unsigned();

            $table->integer('marketplace_id')->unsigned();

            $table->integer('addon_id')->unsigned();
            $table->string('addon_type', 255);

            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }
}
