<?php declare(strict_types=1);

namespace Database\Migrations\v4_1_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class UpdateOperatorSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        // Copy operator_setting value to user table.
        DB::table('user')
            ->join('operator_setting', 'user.id', '=', 'operator_setting.user_id')
            ->update(['user.template_mode' => DB::raw('operator_setting.template_mode')]);

        Schema::table('operator_setting', function (Blueprint $table) {
            $table->dropColumn('template_mode');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->tinyInteger('template_mode')->default(0)->after('template');
        });
    }
}
