<?php declare(strict_types=1);

namespace Database\Migrations\v4_2_0;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;

class UpdateLocaleForeignKey extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        DB::unprepared('alter table `article_type_translation` drop FOREIGN KEY `article_type_translation_locale_foreign`');
        DB::unprepared('alter table `article_type_translation` add FOREIGN KEY `article_type_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_macro_translation` drop FOREIGN KEY `ticket_macro_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_macro_translation` add FOREIGN KEY `ticket_macro_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `schedule_translation` drop FOREIGN KEY `schedule_translation_locale_foreign`');
        DB::unprepared('alter table `schedule_translation` add FOREIGN KEY `schedule_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_status_translation` drop FOREIGN KEY `ticket_status_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_status_translation` add FOREIGN KEY `ticket_status_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_customfield_translation` drop FOREIGN KEY `user_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `user_customfield_translation` add FOREIGN KEY `user_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_translation` drop FOREIGN KEY `article_translation_locale_foreign`');
        DB::unprepared('alter table `article_translation` add FOREIGN KEY `article_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `email_template_translation` drop FOREIGN KEY `email_template_translation_locale_foreign`');
        DB::unprepared('alter table `email_template_translation` add FOREIGN KEY `email_template_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_translation` drop FOREIGN KEY `article_feedback_form_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_translation` add FOREIGN KEY `article_feedback_form_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_feedback_form_field_translation` drop FOREIGN KEY `feedback_form_field_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_field_translation` add FOREIGN KEY `feedback_form_field_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation_customfield_option_translation` drop FOREIGN KEY `user_organisation_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `user_organisation_customfield_option_translation` add FOREIGN KEY `user_organisation_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_customfield_translation` drop FOREIGN KEY `ticket_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_customfield_translation` add FOREIGN KEY `ticket_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_customfield_option_translation` drop FOREIGN KEY `ticket_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_customfield_option_translation` add FOREIGN KEY `ticket_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user` drop FOREIGN KEY `user_language_code_foreign`');
        DB::unprepared('alter table `user` add FOREIGN KEY `user_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE SET NULL');

        DB::unprepared('alter table `ticket_feedback_form_field_option_translation` drop FOREIGN KEY `feedback_form_field_option_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_field_option_translation` add FOREIGN KEY `feedback_form_field_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_tag_translation` drop FOREIGN KEY `article_tag_translation_locale_foreign`');
        DB::unprepared('alter table `article_tag_translation` add FOREIGN KEY `article_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `brand_translation` drop FOREIGN KEY `brand_translation_locale_foreign`');
        DB::unprepared('alter table `brand_translation` add FOREIGN KEY `brand_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_feedback_form_translation` drop FOREIGN KEY `feedback_form_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_translation` add FOREIGN KEY `feedback_form_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_filter_translation` drop FOREIGN KEY `ticket_filter_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_filter_translation` add FOREIGN KEY `ticket_filter_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `email_template_data` drop FOREIGN KEY `email_template_data_language_code_foreign`');
        DB::unprepared('alter table `email_template_data` add FOREIGN KEY `email_template_data_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `sla_plan_translation` drop FOREIGN KEY `sla_plan_translation_locale_foreign`');
        DB::unprepared('alter table `sla_plan_translation` add FOREIGN KEY `sla_plan_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_priority_translation` drop FOREIGN KEY `ticket_priority_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_priority_translation` add FOREIGN KEY `ticket_priority_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `canned_response_tag_translation` drop FOREIGN KEY `canned_response_tag_translation_locale_foreign`');
        DB::unprepared('alter table `canned_response_tag_translation` add FOREIGN KEY `canned_response_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_tag_translation` drop FOREIGN KEY `ticket_tag_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_tag_translation` add FOREIGN KEY `ticket_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_group_translation` drop FOREIGN KEY `user_group_translation_locale_foreign`');
        DB::unprepared('alter table `user_group_translation` add FOREIGN KEY `user_group_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_customfield_option_translation` drop FOREIGN KEY `user_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `user_customfield_option_translation` add FOREIGN KEY `user_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `schedule_holiday_translation` drop FOREIGN KEY `schedule_holiday_translation_locale_foreign`');
        DB::unprepared('alter table `schedule_holiday_translation` add FOREIGN KEY `schedule_holiday_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_attachment` drop FOREIGN KEY `article_attachment_locale_foreign`');
        DB::unprepared('alter table `article_attachment` add FOREIGN KEY `article_attachment_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation_customfield_translation` drop FOREIGN KEY `user_organisation_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `user_organisation_customfield_translation` add FOREIGN KEY `user_organisation_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_field_option_translation` drop FOREIGN KEY `article_feedback_form_field_option_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_field_option_translation` add FOREIGN KEY `article_feedback_form_field_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_category_translation` drop FOREIGN KEY `article_category_translation_locale_foreign`');
        DB::unprepared('alter table `article_category_translation` add FOREIGN KEY `article_category_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `role_translation` drop FOREIGN KEY `role_translation_locale_foreign`');
        DB::unprepared('alter table `role_translation` add FOREIGN KEY `role_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `scheduled_task_translation` drop FOREIGN KEY `scheduled_task_translation_locale_foreign`');
        DB::unprepared('alter table `scheduled_task_translation` add FOREIGN KEY `scheduled_task_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `department_translation` drop FOREIGN KEY `department_translation_locale_foreign`');
        DB::unprepared('alter table `department_translation` add FOREIGN KEY `department_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `canned_response_translation` drop FOREIGN KEY `canned_response_translation_locale_foreign`');
        DB::unprepared('alter table `canned_response_translation` add FOREIGN KEY `canned_response_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_field_translation` drop FOREIGN KEY `article_feedback_form_field_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_field_translation` add FOREIGN KEY `article_feedback_form_field_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation` drop FOREIGN KEY `user_organisation_language_code_foreign`');
        DB::unprepared('alter table `user_organisation` add FOREIGN KEY `user_organisation_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE SET NULL');

        DB::unprepared('alter table `module_translation` drop FOREIGN KEY `module_translation_locale_foreign`');
        DB::unprepared('alter table `module_translation` add FOREIGN KEY `module_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON UPDATE CASCADE ON DELETE CASCADE');
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        DB::unprepared('alter table `article_type_translation` drop FOREIGN KEY `article_type_translation_locale_foreign`');
        DB::unprepared('alter table `article_type_translation` add FOREIGN KEY `article_type_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_macro_translation` drop FOREIGN KEY `ticket_macro_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_macro_translation` add FOREIGN KEY `ticket_macro_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `schedule_translation` drop FOREIGN KEY `schedule_translation_locale_foreign`');
        DB::unprepared('alter table `schedule_translation` add FOREIGN KEY `schedule_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_status_translation` drop FOREIGN KEY `ticket_status_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_status_translation` add FOREIGN KEY `ticket_status_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_customfield_translation` drop FOREIGN KEY `user_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `user_customfield_translation` add FOREIGN KEY `user_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_translation` drop FOREIGN KEY `article_translation_locale_foreign`');
        DB::unprepared('alter table `article_translation` add FOREIGN KEY `article_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `email_template_translation` drop FOREIGN KEY `email_template_translation_locale_foreign`');
        DB::unprepared('alter table `email_template_translation` add FOREIGN KEY `email_template_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_translation` drop FOREIGN KEY `article_feedback_form_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_translation` add FOREIGN KEY `article_feedback_form_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_feedback_form_field_translation` drop FOREIGN KEY `feedback_form_field_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_field_translation` add FOREIGN KEY `feedback_form_field_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation_customfield_option_translation` drop FOREIGN KEY `user_organisation_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `user_organisation_customfield_option_translation` add FOREIGN KEY `user_organisation_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_customfield_translation` drop FOREIGN KEY `ticket_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_customfield_translation` add FOREIGN KEY `ticket_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_customfield_option_translation` drop FOREIGN KEY `ticket_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_customfield_option_translation` add FOREIGN KEY `ticket_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user` drop FOREIGN KEY `user_language_code_foreign`');
        DB::unprepared('alter table `user` add FOREIGN KEY `user_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON DELETE SET NULL');

        DB::unprepared('alter table `ticket_feedback_form_field_option_translation` drop FOREIGN KEY `feedback_form_field_option_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_field_option_translation` add FOREIGN KEY `feedback_form_field_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_tag_translation` drop FOREIGN KEY `article_tag_translation_locale_foreign`');
        DB::unprepared('alter table `article_tag_translation` add FOREIGN KEY `article_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `brand_translation` drop FOREIGN KEY `brand_translation_locale_foreign`');
        DB::unprepared('alter table `brand_translation` add FOREIGN KEY `brand_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_feedback_form_translation` drop FOREIGN KEY `feedback_form_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_feedback_form_translation` add FOREIGN KEY `feedback_form_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_filter_translation` drop FOREIGN KEY `ticket_filter_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_filter_translation` add FOREIGN KEY `ticket_filter_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `email_template_data` drop FOREIGN KEY `email_template_data_language_code_foreign`');
        DB::unprepared('alter table `email_template_data` add FOREIGN KEY `email_template_data_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `sla_plan_translation` drop FOREIGN KEY `sla_plan_translation_locale_foreign`');
        DB::unprepared('alter table `sla_plan_translation` add FOREIGN KEY `sla_plan_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_priority_translation` drop FOREIGN KEY `ticket_priority_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_priority_translation` add FOREIGN KEY `ticket_priority_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `canned_response_tag_translation` drop FOREIGN KEY `canned_response_tag_translation_locale_foreign`');
        DB::unprepared('alter table `canned_response_tag_translation` add FOREIGN KEY `canned_response_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `ticket_tag_translation` drop FOREIGN KEY `ticket_tag_translation_locale_foreign`');
        DB::unprepared('alter table `ticket_tag_translation` add FOREIGN KEY `ticket_tag_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_group_translation` drop FOREIGN KEY `user_group_translation_locale_foreign`');
        DB::unprepared('alter table `user_group_translation` add FOREIGN KEY `user_group_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_customfield_option_translation` drop FOREIGN KEY `user_customfield_option_translation_locale_foreign`');
        DB::unprepared('alter table `user_customfield_option_translation` add FOREIGN KEY `user_customfield_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `schedule_holiday_translation` drop FOREIGN KEY `schedule_holiday_translation_locale_foreign`');
        DB::unprepared('alter table `schedule_holiday_translation` add FOREIGN KEY `schedule_holiday_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_attachment` drop FOREIGN KEY `article_attachment_locale_foreign`');
        DB::unprepared('alter table `article_attachment` add FOREIGN KEY `article_attachment_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation_customfield_translation` drop FOREIGN KEY `user_organisation_customfield_translation_locale_foreign`');
        DB::unprepared('alter table `user_organisation_customfield_translation` add FOREIGN KEY `user_organisation_customfield_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_field_option_translation` drop FOREIGN KEY `article_feedback_form_field_option_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_field_option_translation` add FOREIGN KEY `article_feedback_form_field_option_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_category_translation` drop FOREIGN KEY `article_category_translation_locale_foreign`');
        DB::unprepared('alter table `article_category_translation` add FOREIGN KEY `article_category_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `role_translation` drop FOREIGN KEY `role_translation_locale_foreign`');
        DB::unprepared('alter table `role_translation` add FOREIGN KEY `role_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `scheduled_task_translation` drop FOREIGN KEY `scheduled_task_translation_locale_foreign`');
        DB::unprepared('alter table `scheduled_task_translation` add FOREIGN KEY `scheduled_task_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `department_translation` drop FOREIGN KEY `department_translation_locale_foreign`');
        DB::unprepared('alter table `department_translation` add FOREIGN KEY `department_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `canned_response_translation` drop FOREIGN KEY `canned_response_translation_locale_foreign`');
        DB::unprepared('alter table `canned_response_translation` add FOREIGN KEY `canned_response_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `article_feedback_form_field_translation` drop FOREIGN KEY `article_feedback_form_field_translation_locale_foreign`');
        DB::unprepared('alter table `article_feedback_form_field_translation` add FOREIGN KEY `article_feedback_form_field_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');

        DB::unprepared('alter table `user_organisation` drop FOREIGN KEY `user_organisation_language_code_foreign`');
        DB::unprepared('alter table `user_organisation` add FOREIGN KEY `user_organisation_language_code_foreign` (`language_code`) REFERENCES `language` (`code`) ON DELETE SET NULL');

        DB::unprepared('alter table `module_translation` drop FOREIGN KEY `module_translation_locale_foreign`');
        DB::unprepared('alter table `module_translation` add FOREIGN KEY `module_translation_locale_foreign` (`locale`) REFERENCES `language` (`code`) ON DELETE CASCADE');
    }
}
