<?php declare(strict_types=1);

namespace Database\Migrations\v4_2_0\Core;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Schema;

class CreateEmailLogAttachmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('email_log_attachments', function (Blueprint $table) {
            $table->engine = 'InnoDB';

            $table->charset = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->integer('log_id')->unsigned();
            $table->foreign('log_id')->references('id')->on('email_log')->onDelete('cascade');

            $table->integer('upload_id')->unsigned();
            $table->foreign('upload_id')->references('id')->on('upload')->onDelete('cascade');

            $table->string('original_name');
        });
    }
}
