<?php declare(strict_types=1);

namespace Database\Migrations\v4_2_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

use function sprintf;

class UpdateOperatorSignatureTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::rename('operator_signature', 'operator_reply_template');

        DB::table('permission')
            ->where('name', 'LIKE', 'operatorsignature')
            ->update(['name' => 'operatorreplytemplate', 'description' => 'operatorreplytemplate']);

        // Update all tables that use merge field.
        $this->updateColumn('sla_escalation_rule', 'value_text', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('ticket_macro_action', 'value_text', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('ticket_followup_action', 'value_text', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('canned_response', 'text', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('canned_response_translation', 'text', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('email_template_data', 'contents', 'operator.signature', 'operator.reply_template');
        $this->updateColumn('operator_reply_template', 'contents', 'operator.signature', 'operator.reply_template');

        DB::table('operator_reply_template')
            ->update(['contents' => DB::raw("CONCAT('<p></p>\n<p></p>\n', `contents`)")]);
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::rename('operator_reply_template', 'operator_signature');

        DB::table('permission')
            ->where('name', 'LIKE', 'operatorreplytemplate')
            ->update(['name' => 'operatorsignature', 'description' => 'operatorsignature']);

        // Update all tables that use merge field.
        $this->updateColumn('sla_escalation_rule', 'value_text', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('ticket_macro_action', 'value_text', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('ticket_followup_action', 'value_text', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('canned_response', 'text', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('canned_response_translation', 'text', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('email_template_data', 'contents', 'operator.reply_template', 'operator.signature');
        $this->updateColumn('operator_signature', 'contents', 'operator.reply_template', 'operator.signature');

        DB::table('operator_signature')
            ->update(['contents' => DB::raw("IF(SUBSTR(`contents`, 1, 16) = '<p></p>\n<p></p>\n', SUBSTR(`contents`, 17), `contents`)")]);
    }

    /**
     * Update all values in a column within the table.
     */
    private function updateColumn(string $table, string $column, string $string1, string $string2): void
    {
        DB::table($table)
            ->update([$column => DB::raw(sprintf("REPLACE(`%s`, '%s', '%s')", $column, $string1, $string2))]);
    }
}
