<?php declare(strict_types=1);

namespace Database\Migrations\v4_2_0\User;

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class UpdateOperatorSettingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->enum('shortcuts_enabled', [0, 1])->default(0)->after('widget_version_check');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('operator_setting', function (Blueprint $table) {
            $table->dropColumn('shortcuts_enabled');
        });
    }
}
