<?php
/**
 * File 2015_08_08_162001_seed_module_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedModuleTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedModuleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('module')->insert([
            [
                'id'      => 1,
                'name'    => 'Core',
                'slug'    => 'Core',
                'enabled' => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ],[
                'id'      => 2,
                'name'    => 'User',
                'slug'    => 'User',
                'enabled' => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ],[
                'id'      => 3,
                'name'    => 'Ticket',
                'slug'    => 'Ticket',
                'enabled' => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ],[
                'id'      => 4,
                'name'    => 'Self-Service',
                'slug'    => 'Selfservice',
                'enabled' => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ],[
                'id'      => 5,
                'name'    => 'Report',
                'slug'    => 'Report',
                'enabled' => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ]
        ]);
    }
}
