<?php
/**
 * File 2015_08_08_162003_seed_permission_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPermissionTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        DB::table('permission')->insert([
            [
                'module_id'   => 1,
                'name'        => 'apitoken',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'apitoken',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'coresetting',
                'slug'        => '{"view":true,"update":true}',
                'description' => 'generalsetting',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'dashboard',
                'slug'        => '{"view":true}',
                'description' => 'dashboard',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'emailtemplate',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'emailtemplate',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'ipban',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'ipban',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'ipwhitelist',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'ipwhitelist',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'language',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'language',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'license',
                'slug'        => '{"view":true}',
                'description' => 'license',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'module',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'module',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'plugin',
                'slug'        => '{"view":true,"update":true}',
                'description' => 'plugin',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'scheduledtask',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'scheduledtask',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'spamrule',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'spamrule',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'emaillog',
                'slug'        => '{"view":true}',
                'description' => 'emaillog',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 1,
                'name'        => 'systemcleanup',
                'slug'        => '{"view":true}',
                'description' => 'systemcleanup',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'operatorgroup',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'operatorgroup',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'organisation',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'organisation',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'role',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'role',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'user',
                'slug'        => '{"view":true}',
                'description' => 'user_view',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'user',
                'slug'        => '{"create":true}',
                'description' => 'user_add',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'user',
                'slug'        => '{"update":true}',
                'description' => 'user_edit',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'user',
                'slug'        => '{"delete":true}',
                'description' => 'user_delete',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'usercustomfield',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'usercustomfield',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'usergroup',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'usergroup',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'massemail',
                'slug'        => '{"view":true}',
                'description' => 'massemail',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'usersetting',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'generalsetting',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'ldapaccount',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'ldapaccount',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'activitylog',
                'slug'        => '{"view":true}',
                'description' => 'activitylog',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 2,
                'name'        => 'operatorlog',
                'slug'        => '{"view":true}',
                'description' => 'operatorlog',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'cannedresponse',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'cannedresponse',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'channel',
                'slug'        => '{"view":true,"update":true}',
                'description' => 'channel',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'department',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'department',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'feedback',
                'slug'        => '{"view":true,"update":true,"delete":true}',
                'description' => 'feedback',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'feedbackform',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'feedbackform',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'filter',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'filter',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'holiday',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'holiday',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'macro',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'macro',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'priority',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'priority',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'schedule',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'schedule',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'slaplan',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'slaplan',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'status',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'status',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticket',
                'slug'        => '{"view":true}',
                'description' => 'ticket_view',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticket',
                'slug'        => '{"create":true}',
                'description' => 'ticket_add',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticket',
                'slug'        => '{"update":true}',
                'description' => 'ticket_edit',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticket',
                'slug'        => '{"delete":true}',
                'description' => 'ticket_delete',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticketcustomfield',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'ticketcustomfield',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'ticketsetting',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'generalsetting',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 3,
                'name'        => 'tickettag',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'tag',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'article',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'article',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'category',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'category',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'comment',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'comment',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'selfservicesetting',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'generalsetting',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'selfservicetag',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'tag',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 4,
                'name'        => 'selfservicetype',
                'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
                'description' => 'selfservicetype',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 5,
                'name'        => 'report',
                'slug'        => '{"view":true}',
                'description' => 'report',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'module_id'   => 5,
                'name'        => 'reportdashboard',
                'slug'        => '{"view":true}',
                'description' => 'reportdashboard',
                'created_at'  => $time,
                'updated_at'  => $time,
            ]
        ]);
    }
}
