<?php declare(strict_types=1);

/**
 * File 2015_08_08_162004_seed_role_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

use function time;

/**
 * Class SeedRoleTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedRoleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Insert the default role
        DB::table('role')->insert([
            'id'          => 1,
            'name'        => 'Administrator',
            'slug'        => 'administrator',
            'description' => 'Full permissions',
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);

        // Fetch all permissions
        $permissions = DB::table('permission')->pluck('id');

        // Add relationship for all permissions
        foreach ($permissions as $permission) {
            DB::table('permission_role')->insert([
                'permission_id' => $permission,
                'role_id'       => 1
            ]);
        }
    }
}
