<?php declare(strict_types=1);

/**
 * File 2015_08_08_162005_seed_user_group_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use DB;

use function time;

/**
 * Class SeedUserGroupTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedUserGroupTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Insert the default operator group
        DB::table('user_group')->insert([
            'id'          => 1,
            'name'        => 'System Administrators',
            'description' => 'Default group for administrators, always has all permissions.',
            'colour'      => '#777777',
            'administrator' => 1,
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);

        DB::table('group_role_membership')->insert([
            'group_id' => 1,
            'role_id'  => 1, // Hardcoded in database/seeds/2.0.0-beta1/2015_08_08_162004_seed_role_table.php
        ]);
    }
}
