<?php
/**
 * File 2015_08_08_162006_seed_ticket_priority_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedTicketPriorityTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedTicketPriorityTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        DB::table('ticket_priority')->insert([
            [
                'name'       => 'Low',
                'colour'     => '#3498db',
                'order'      => 1,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'Medium',
                'colour'     => '#e67e22',
                'order'      => 2,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'High',
                'colour'     => '#e74c3c',
                'order'      => 3,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'Critical',
                'colour'     => '#9b59b6',
                'order'      => 4,
                'created_at' => $time,
                'updated_at' => $time,
            ]
        ]);
    }
}
