<?php
/**
 * File 2015_08_08_162007_seed_ticket_status_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedTicketStatusTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedTicketStatusTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        DB::table('ticket_status')->insert([
            [
                'name'       => 'Open',
                'colour'     => '#35a600',
                'auto_close' => 1,
                'order'      => 1,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'Closed',
                'colour'     => '#454545',
                'auto_close' => 0,
                'order'      => 4,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'Awaiting Reply',
                'colour'     => '#1e79a6',
                'auto_close' => 1,
                'order'      => 2,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'name'       => 'In-Progress',
                'colour'     => '#d42d2d',
                'auto_close' => 0,
                'order'      => 3,
                'created_at' => $time,
                'updated_at' => $time,
            ]
        ]);
    }
}
