<?php
/**
 * File 2015_08_08_162008_seed_ticket_filter_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedTicketFilterTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedTicketFilterTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        $inboxId = DB::table('ticket_filter')->insertGetId([
            'name'                 => 'Inbox',
            'all_groups'           => 1,
            'condition_group_type' => 1,
            'created_at'           => $time,
            'updated_at'           => $time,
        ]);
        $assignedToMeId = DB::table('ticket_filter')->insertGetId([
            'name'                 => 'Assigned to Me',
            'all_groups'           => 1,
            'condition_group_type' => 1,
            'created_at'           => $time,
            'updated_at'           => $time,
        ]);

        $group1Id = DB::table('ticket_filter_condition_group')->insertGetId([
            'filter_id'  => $inboxId,
            'type'       => 0,
            'created_at' => $time,
            'updated_at' => $time,
        ]);
        $group2Id = DB::table('ticket_filter_condition_group')->insertGetId([
            'filter_id'  => $inboxId,
            'type'       => 0,
            'created_at' => $time,
            'updated_at' => $time,
        ]);
        $group3Id = DB::table('ticket_filter_condition_group')->insertGetId([
            'filter_id'  => $assignedToMeId,
            'type'       => 0,
            'created_at' => $time,
            'updated_at' => $time,
        ]);

        DB::table('ticket_filter_condition')->insert([
            [
                'group_id'   => $group1Id,
                'item'       => 0,
                'operator'   => 0,
                'value'      => -1,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'group_id'   => $group1Id,
                'item'       => 13,
                'operator'   => 1,
                'value'      => 2,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'group_id'   => $group2Id,
                'item'       => 0,
                'operator'   => 0,
                'value'      => 0,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'group_id'   => $group2Id,
                'item'       => 13,
                'operator'   => 1,
                'value'      => 2,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'group_id'   => $group3Id,
                'item'       => 0,
                'operator'   => 0,
                'value'      => 0,
                'created_at' => $time,
                'updated_at' => $time,
            ],[
                'group_id'   => $group3Id,
                'item'       => 13,
                'operator'   => 1,
                'value'      => 2,
                'created_at' => $time,
                'updated_at' => $time,
            ]
        ]);
    }
}
