<?php
/**
 * File 2015_08_08_162009_seed_department_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedDepartmentTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedDepartmentTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Insert the default operator group
        $id = DB::table('department')->insertGetId([
            'name'        => 'Support',
            'description' => 'This is an automatically generated department, please edit me.',
            'order'       => 1,
            'public'      => 1,
            'notify_email_ticket'     => 1,
            'notify_operators'        => 1,
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);

        // Add a default department e-mail
        DB::table('department_email')->insert([
            'department_id' => $id,
            'address'       => 'support@my.company',
            'type'          => 0,
            'created_at'    => time(),
            'updated_at'    => time(),
        ]);

        // Fetch all priorities
        $priorities = DB::table('ticket_priority')->pluck('id');

        // Add relationship with priorities
        foreach ($priorities as $priority) {
            DB::table('department_priority_membership')->insert([
                'department_id' => $id,
                'priority_id'   => $priority
            ]);
        }
    }
}
