<?php
/**
 * File 2015_08_08_162010_seed_schedule_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedScheduleTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedScheduleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        // Insert the default schedule
        $id = DB::table('schedule')->insertGetId([
            'name'         => 'Default',
            'description'  => 'Default schedule for help desk',
            'created_at'   => $time,
            'updated_at'   => $time,
        ]);

        // Insert schedule hours
        DB::table('schedule_hours')->insert([
            [
                'schedule_id'  => $id,
                'day'          => 1,
                'type'         => 1,
                'start_hour'   => 9,
                'start_minute' => 0,
                'end_hour'     => 17,
                'end_minute'   => 0,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 2,
                'type'         => 1,
                'start_hour'   => 9,
                'start_minute' => 0,
                'end_hour'     => 17,
                'end_minute'   => 0,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 3,
                'type'         => 1,
                'start_hour'   => 9,
                'start_minute' => 0,
                'end_hour'     => 17,
                'end_minute'   => 0,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 4,
                'type'         => 1,
                'start_hour'   => 9,
                'start_minute' => 0,
                'end_hour'     => 17,
                'end_minute'   => 0,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 5,
                'type'         => 1,
                'start_hour'   => 9,
                'start_minute' => 0,
                'end_hour'     => 17,
                'end_minute'   => 0,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 6,
                'type'         => 2,
                'start_hour'   => null,
                'start_minute' => null,
                'end_hour'     => null,
                'end_minute'   => null,
                'created_at'   => $time,
                'updated_at'   => $time,
            ],[
                'schedule_id'  => $id,
                'day'          => 7,
                'type'         => 2,
                'start_hour'   => null,
                'start_minute' => null,
                'end_hour'     => null,
                'end_minute'   => null,
                'created_at'   => $time,
                'updated_at'   => $time,
            ]
        ]);
    }
}
