<?php
/**
 * File 2015_08_08_162011_seed_ticket_channel_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use Addons\Channels\API\Controllers\API;
use Addons\Channels\Email\Controllers\Email;
use Addons\Channels\Web\Controllers\Web;
use App\Modules\Ticket\Models\Priority;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedTicketChannelTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedTicketChannelTable extends Seeder
{
    /**
     * Activate the three default channels
     *
     * @return void
     */
    public function run()
    {
        // Web
        $id = DB::table('ticket_channel')->insertGetId([
            'name'       => 'Web',
            'enabled'    => 1,
            'class'      => Web::class,
            'created_at' => time(),
            'updated_at' => time(),
        ]);
        DB::table('ticket_channel_setting')
            ->insert([
                [
                    'channel_id' => $id,
                    'name'       => 'unauthenticated_users',
                    'value'      => 1,
                    'created_at' => time(),
                    'updated_at' => time(),
                ],
                [
                    'channel_id' => $id,
                    'name'       => 'show_captcha',
                    'value'      => 1,
                    'created_at' => time(),
                    'updated_at' => time(),
                ],
                [
                    'channel_id' => $id,
                    'name'       => 'show_related_articles',
                    'value'      => 1,
                    'created_at' => time(),
                    'updated_at' => time(),
                ],
            ]);

        // Email
        $id = DB::table('ticket_channel')->insertGetId([
            'name'       => 'Email',
            'enabled'    => 1,
            'class'      => Email::class,
            'created_at' => time(),
            'updated_at' => time(),
        ]);

        DB::table('scheduled_task')
            ->insert([
                'name'        => 'Check email accounts',
                'description' => 'Download emails via IMAP/POP3 and convert them to tickets.',
                'class'       => Email::class,
                'interval'    => 285,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ]);

        DB::table('ticket_channel_setting')
            ->insert([
                [
                    'channel_id' => $id,
                    'name'       => 'default_priority',
                    'value'      => Priority::first()->id,
                    'created_at' => time(),
                    'updated_at' => time(),
                ],
                [
                    'channel_id' => $id,
                    'name'       => 'verbose_log',
                    'value'      => 0,
                    'created_at' => time(),
                    'updated_at' => time(),
                ],
            ]);

        // API
        DB::table('ticket_channel')->insertGetId([
            'name'       => 'API',
            'enabled'    => 1,
            'class'      => API::class,
            'created_at' => time(),
            'updated_at' => time(),
        ]);
    }
}
