<?php
/**
 * File 2015_08_08_162012_seed_article_type_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedArticleTypeTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedArticleTypeTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Insertion time
        $time = time();

        DB::table('article_type')->insert([
            [
                'name'        => 'Announcements',
                'slug'        => 'announcements',
                'description' => 'View the latest news and announcements.',
                'order'       => 1,
                'enabled'     => 1,
                'view'        => 1,
                'icon'        => '',
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'name'        => 'Knowledgebase',
                'slug'        => 'knowledgebase',
                'description' => 'Browse the knowledgebase to find answers to commonly asked questions.',
                'order'       => 2,
                'enabled'     => 1,
                'view'        => 0,
                'icon'        => '',
                'created_at'  => $time,
                'updated_at'  => $time,
            ]
        ]);
    }
}
