<?php
/**
 * File 2015_08_08_162013_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use Illuminate\Support\Str;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        DB::table('setting')->insert([
            [
                'module_id' => 1,
                'name' => 'active_plugins',
                'value' => '',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'admin_folder',
                'value' => 'admin',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'date_format',
                'value' => 'd/m/Y',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'default_country',
                'value' => 'AF',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'default_frontend_language',
                'value' => 'en',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'default_operator_language',
                'value' => 'en',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'default_email',
                'value' => 'email@yourcompany.com',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'default_timezone',
                'value' => 'Europe/London',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'enable_ssl',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'force_operator_ssl',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'frontend_language',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'frontend_template',
                'value' => 'default',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'is_installed',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'language_frontend_toggle',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'language_operator_toggle',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'maintenance_mode',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'operator_language',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'operator_template',
                'value' => 'default',
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'simpleauth_key',
                'value' => Str::random(32),
                'created_at' => $time,
            ], [
                'module_id' => 1,
                'name' => 'time_format',
                'value' => 'g:i A',
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'ldap_enabled',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'operator_password_length',
                'value' => 8,
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'registration_captcha',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'registration_enabled',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'user_name_format',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 2,
                'name' => 'user_password_length',
                'value' => 6,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'allowed_files',
                'value' => 'doc|docx|xml|png|gif|jpg|jpeg|zip|rar|pdf|txt|log',
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'default_open_status',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'default_resolved_status',
                'value' => 2,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'inactive_close_time',
                'value' => 604800,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'ticket_notes_position',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'ticket_number_format',
                'value' => '%N{7}',
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'ticket_reply_order',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 3,
                'name' => 'waiting_response_time',
                'value' => 345600,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_captcha',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_moderation',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_ordering',
                'value' => 2,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_ratings',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_threshold',
                'value' => -2,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comment_write',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'comments_enabled',
                'value' => 1,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'rating_post',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'rating_show',
                'value' => 0,
                'created_at' => $time,
            ], [
                'module_id' => 4,
                'name' => 'ratings_enabled',
                'value' => 1,
                'created_at' => $time,
            ]
        ]);
    }
}
