<?php
/**
 * File 2015_08_08_162015_seed_email_template_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Models\EmailTemplate;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedEmailTemplateTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
        DB::table('email_template')->insert([
            [
                'id'          => 1,
                'name'        => 'Assigned operator to ticket',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 2,
                'name'        => 'New ticket reply',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 3,
                'name'        => 'New ticket opened',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 4,
                'name'        => 'New ticket opened',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 5,
                'name'        => 'New ticket reply',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 6,
                'name'        => 'Password reset',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 7,
                'name'        => 'IP banned due to failed log in attempts',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 8,
                'name'        => 'Reply to locked ticket',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 9,
                'name'        => 'Password reset',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 10,
                'name'        => 'Reply to comment',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 11,
                'name'        => 'Waiting for your response',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 12,
                'name'        => 'Added as new organisation user',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 13,
                'name'        => 'Ticket closed due to inactivity',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 14,
                'name'        => 'Failed login attempt',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 15,
                'name'        => 'New internal message',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 16,
                'name'        => 'New automatic user registration',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 17,
                'name'        => 'New comment posted',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 18,
                'name'        => 'New internal ticket opened',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 19,
                'name'        => 'Ticket department changed',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 20,
                'name'        => 'Ticket closed by operator',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 21,
                'name'        => 'Attachment rejected',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 22,
                'name'        => 'Account confirmation',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 23,
                'name'        => 'Operator replied to ticket',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 24,
                'name'        => 'Operator added a ticket note',
                'description' => '',
                'type'        => EmailTemplate::OPERATOR,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 25,
                'name'        => 'Ticket feedback request',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ],[
                'id'          => 26,
                'name'        => 'New account details',
                'description' => '',
                'type'        => EmailTemplate::USER,
                'created_at'  => $time,
                'updated_at'  => $time,
            ]
        ]);
    }
}
