<?php
/**
 * File 2015_08_08_162016_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Create timestamps
        $time = time();

        // Insert into the DB - Fluent doesn't handle $timestamps so we add them manually
        DB::table('email_template_data')->insert([
            'template_id' => 1,
            'subject'     => '(#{{ ticket.number }}) You have been assigned to a ticket',
            'contents'    => file_get_contents(__DIR__.'/emails/template_1.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 2,
            'subject'     => 'RE: (#{{ ticket.number }}) {{ ticket.subject }}',
            'contents'    => file_get_contents(__DIR__.'/emails/template_2.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 3,
            'subject'     => '(#{{ ticket.number }}) {{ ticket.subject }}',
            'contents'    => file_get_contents(__DIR__.'/emails/template_3.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 4,
            'subject'     => '(#{{ ticket.number }}) A new ticket has been opened',
            'contents'    => file_get_contents(__DIR__.'/emails/template_4.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 5,
            'subject'     => '(#{{ ticket.number }}) A new ticket reply',
            'contents'    => file_get_contents(__DIR__.'/emails/template_5.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 6,
            'subject'     => 'Password reset confirmation',
            'contents'    => file_get_contents(__DIR__.'/emails/template_6.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 7,
            'subject'     => 'IP banned due to failed login attempts',
            'contents'    => file_get_contents(__DIR__.'/emails/template_7.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 8,
            'subject'     => 'Please open a new ticket',
            'contents'    => file_get_contents(__DIR__.'/emails/template_8.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 9,
            'subject'     => 'Password reset confirmation',
            'contents'    => file_get_contents(__DIR__.'/emails/template_9.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 10,
            'subject'     => 'A reply has been posted to your comment',
            'contents'    => file_get_contents(__DIR__.'/emails/template_10.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 11,
            'subject'     => '(#{{ ticket.number }}) Waiting for your response',
            'contents'    => file_get_contents(__DIR__.'/emails/template_11.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 12,
            'subject'     => 'Your help desk account has been created',
            'contents'    => file_get_contents(__DIR__.'/emails/template_12.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 13,
            'subject'     => '(#{{ ticket.number }}) Your ticket was closed due to inactivity',
            'contents'    => file_get_contents(__DIR__.'/emails/template_13.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 14,
            'subject'     => 'Failed operator login attempt',
            'contents'    => file_get_contents(__DIR__.'/emails/template_14.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 15,
            'subject'     => 'New internal message from {{ private.user.formatted_name }}',
            'contents'    => file_get_contents(__DIR__.'/emails/template_15.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 16,
            'subject'     => 'Your help desk account has been created',
            'contents'    => file_get_contents(__DIR__.'/emails/template_16.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 17,
            'subject'     => 'A new comment has been posted',
            'contents'    => file_get_contents(__DIR__.'/emails/template_17.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 18,
            'subject'     => '(#{{ ticket.number }}) A new internal ticket has been opened',
            'contents'    => file_get_contents(__DIR__.'/emails/template_18.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 19,
            'subject'     => '(#{{ ticket.number }}) Ticket department changed',
            'contents'    => file_get_contents(__DIR__.'/emails/template_19.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 20,
            'subject'     => '(#{{ ticket.number }}) Ticket has been marked as resolved',
            'contents'    => file_get_contents(__DIR__.'/emails/template_20.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 21,
            'subject'     => 'Your attachment was rejected',
            'contents'    => file_get_contents(__DIR__.'/emails/template_21.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 22,
            'subject'     => 'Account confirmation',
            'contents'    => file_get_contents(__DIR__.'/emails/template_22.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 23,
            'subject'     => '(#{{ ticket.number }}) New operator reply',
            'contents'    => file_get_contents(__DIR__.'/emails/template_23.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 24,
            'subject'     => '(#{{ ticket.number }}) New ticket note',
            'contents'    => file_get_contents(__DIR__.'/emails/template_24.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 25,
            'subject'     => '(#{{ ticket.number }}) How do you rate the support?',
            'contents'    => file_get_contents(__DIR__.'/emails/template_25.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
        DB::table('email_template_data')->insert([
            'template_id' => 26,
            'subject'     => 'A user account has been created for you',
            'contents'    => file_get_contents(__DIR__.'/emails/template_26.twig'),
            'created_at'  => $time,
            'updated_at'  => $time
        ]);
    }
}
