<?php
/**
 * File 2015_08_08_162017_seed_scheduled_task_table.php
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\Beta1;

use App\Modules\Core\Models\EmailQueue;
use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Ticket\Models\FeedbackQueue;
use App\Modules\Ticket\Models\FollowUp;
use App\Modules\Ticket\Models\Macro;
use App\Modules\Ticket\Models\Ticket;
use App\Modules\Ticket\Models\TicketEscalationRule;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedScheduledTaskTable
 *
 * @package    Database\Seeds\v2_0_0\Beta1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedScheduledTaskTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('scheduled_task')->insert([
            [
                'name'        => 'Process ticket escalation rules',
                'description' => 'Checks if any escalation rules have been triggered and processed them.',
                'class'       => TicketEscalationRule::class,
                'interval'    => 885,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Process automatic ticket macros',
                'description' => 'Checks if any automatic macros now fit the conditions on unresolved tickets (on which it has not previous ran) and runs them.',
                'class'       => Macro::class,
                'interval'    => 885,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Process ticket follow ups',
                'description' => 'Checks if a ticket follow up is due and runs the actions.',
                'class'       => FollowUp::class,
                'interval'    => 885,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Handle inactive tickets',
                'description' => 'Sends waiting for response emails and closes tickets that have become inactive with no follow up from the user.',
                'class'       => Ticket::class,
                'interval'    => 3585,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Send ticket feedback forms',
                'description' => 'Sends feedback forms to users with resolved tickets. Also expires sent incomplete forms that are now past their expiry time.',
                'class'       => FeedbackQueue::class,
                'interval'    => 3585,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ],
            [
                'name'        => 'Process email queue',
                'description' => 'Processes pending emails in the queue waiting to be sent.',
                'class'       => EmailQueue::class,
                'interval'    => 45,
                'last_run'    => 0,
                'running'     => 0,
                'created_at'  => time(),
                'updated_at'  => time(),
            ]
        ]);
    }
}
