<?php
/**
 * File 2016_04_20_173001_seed_department_table.php
 *
 * @package    Database\Seeds\v2_0_0\RC1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.0
 */
namespace Database\Seeds\v2_0_0\RC1;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedDepartmentTable
 *
 * @package    Database\Seeds\v2_0_0\RC1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.0
 */
class SeedDepartmentTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get all departments
        $departments = DB::table('department')->get([ 'id', 'email_templates' ]);

        foreach ($departments as $department) {
            // If we have a serialized value
            if (! is_null($department->email_templates)) {
                // Unserialize to an array
                $emailTemplates = unserialize($department->email_templates);

                // Check if the waiting response email is set
                if (! isset($emailTemplates['ticket_waitingresponse'])) {
                    $emailTemplates['ticket_waitingresponse'] = 11;
                }

                // Update field for this record (use json instead)
                DB::table('department')
                    ->where('id', $department->id)
                    ->update([ 'email_templates' => json_encode($emailTemplates) ]);
            }
        }
    }
}
