<?php
/**
 * File 2016_06_01_183800_seed_storage_table.php
 *
 * @package    Database\Seeds\v2_0_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.1
 */
namespace Database\Seeds\v2_0_1;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use RecursiveDirectoryIterator;
use RecursiveIteratorIterator;

/**
 * Class SeedStorageTable
 *
 * @package    Database\Seeds\v2_0_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.1
 */
class SeedStorageTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $directories = [
            storage_path('tickets')         => storage_path('app'.DIRECTORY_SEPARATOR.'tickets'),
            storage_path('selfservice')     => storage_path('app'.DIRECTORY_SEPARATOR.'selfservice'),
            storage_path('rss_cache')       => storage_path('app'.DIRECTORY_SEPARATOR.'rss_cache')
        ];

        foreach ($directories as $old_path => $new_path) {
            // Ensure the old path exists.
            if (file_exists($old_path) && is_dir($old_path)) {
                // Check whether we need to create the new path.
                if (!file_exists($new_path) && !is_dir($new_path)) {
                    mkdir($new_path, 0777, true);
                }

                // Make sure the new directory is empty.
                $this->emptyDirectory($new_path);

                if (@rename($old_path, $new_path) === false) {
                    $this->note(
                        "<info>ERROR: Failed to move '$old_path' to '$new_path'. Please move manually.</info>"
                    );
                }
            }
        }
    }

    /**
     * Delete all files from directory.
     *
     * @param  string $path
     * @return void
     */
    private function emptyDirectory($path)
    {
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($path, RecursiveDirectoryIterator::SKIP_DOTS),
            RecursiveIteratorIterator::CHILD_FIRST
        );

        foreach ($files as $fileinfo) {
            $func = ($fileinfo->isDir() ? 'rmdir' : 'unlink');
            @$func($fileinfo->getRealPath());
        }
    }
}
