<?php
/**
 * File 2016_06_01_183801_seed_widget_table.php
 *
 * @package    Database\Seeds\v2_0_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.1
 */
namespace Database\Seeds\v2_0_1;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\Core\Models\Repository\SettingsRepository;
use DB;

use Illuminate\Contracts\Container\Container;
use function time;

/**
 * Class SeedWidgetTable
 *
 * @package    Database\Seeds\v2_0_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.1
 */
class SeedWidgetTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // We only want to run this seed as part of upgrades. The same functionality exists in the install:operator
        // command for new installations.
        if ($this->container->make(SettingsRepository::class)->isInstalled() === false) {
            return;
        }

        // Check if version check widget exists
        $widget = DB::table('widget')->where('id', 'LIKE', 'VersionCheck')->count();

        // Add widget if it doesn't exist
        if ($widget === 0) {
            DB::table('widget')->insert([
                'id'         => 'VersionCheck',
                'name'       => 'Version Check',
                'created_at' => time(),
                'updated_at' => time()
            ]);
        }

        // Fetch operators
        $operators = DB::table('operator_widget')->select('user_id')->distinct()->get();

        // Add widget for each operator
        foreach ($operators as $operator) {
            DB::table('operator_widget')->insert([
                'user_id'    => $operator->user_id,
                'widget_id'  => 'VersionCheck',
                'enabled'    => 1,
                'created_at' => time(),
                'updated_at' => time()
            ]);
        }
    }
}
