<?php
/**
 * File 2016_07_05_163801_seed_plugin_role_table.php
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Seeds\v2_0_2;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPluginRoleTable
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.2
 */
class SeedPluginRoleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get all plugins and roles.
        $plugins = DB::table('plugin')->get();
        $roles = DB::table('role')->get();

        // Add a permission for each set of roles and plugins.
        foreach ($roles as $role) {
            foreach ($plugins as $plugin) {
                DB::table('plugin_role')->insert([
                    'plugin_id'  => $plugin->id,
                    'role_id'    => $role->id,
                    'permission' => 1
                ]);
            }
        }
    }
}
