<?php
/**
 * File 2016_07_05_163802_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Seeds\v2_0_2;

use Addons\Channels\Email\Controllers\Email;
use App\Modules\Ticket\Models\Channel;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.1
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('setting')->insert([
            [
                'module_id'  => 2,
                'name'       => 'ban_after_count_user',
                'value'      => 3,
                'created_at' => time()
            ], [
                'module_id'  => 2,
                'name'       => 'ban_length_user',
                'value'      => 900,
                'created_at' => time()
            ], [
                'module_id'  => 2,
                'name'       => 'ban_after_count_operator',
                'value'      => 3,
                'created_at' => time()
            ], [
                'module_id'  => 2,
                'name'       => 'ban_length_operator',
                'value'      => 900,
                'created_at' => time()
            ]
        ]);

        // Enable the verbose email log by default.
        $channel = Channel::where('name', Email::IDENTIFIER)->first();
        DB::table('ticket_channel_setting')
            ->where('channel_id', $channel->id)
            ->where('name', 'verbose_log')
            ->update([ 'value' => 1 ]);
    }
}
