<?php
/**
 * File 2016_07_05_163803_seed_widget_role_table.php
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.2
 */
namespace Database\Seeds\v2_0_2;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedWidgetRoleTable
 *
 * @package    Database\Seeds\v2_0_2
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.2
 */
class SeedWidgetRoleTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Get all widgets and roles.
        $widgets = DB::table('widget')->get();
        $roles = DB::table('role')->get();

        // Add a permission for each set of roles and widgets.
        foreach ($roles as $role) {
            foreach ($widgets as $widget) {
                DB::table('widget_role')->insert([
                    'widget_id'  => $widget->id,
                    'role_id'    => $role->id,
                    'permission' => 1
                ]);
            }
        }
    }
}
