<?php
/**
 * File 2016_08_23_171900_seed_channel_setting_table.php
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Seeds\v2_0_3;

use Addons\Channels\Web\Controllers\Web;
use App\Modules\Ticket\Models\Channel;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedChannelSettingTable
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class SeedChannelSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $channel = Channel::where('name', (new Web)->getIdentifier())->first();

        DB::table('ticket_channel_setting')
            ->insert([
                'channel_id' => $channel->id,
                'name'       => 'append_ip_address',
                'value'      => 1,
                'created_at' => time(),
                'updated_at' => time(),
            ]);
    }
}
