<?php
/**
 * File 2016_08_23_171902_seed_permission_table.php
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Seeds\v2_0_3;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPermissionTable
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class SeedPermissionTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $id = DB::table('permission')->insertGetId([
            'module_id'   => 2,
            'name'        => 'operator',
            'slug'        => '{"view":true,"create":true,"update":true,"delete":true}',
            'description' => 'operator',
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);

        // Get first role
        $role = DB::table('role')->first();

        // Add relationship for permission and role
        DB::table('permission_role')->insert([
            'permission_id' => $id,
            'role_id'       => $role->id
        ]);
    }
}
