<?php
/**
 * File 2016_08_23_171903_seed_scheduled_task_table.php
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Seeds\v2_0_3;

use App\Modules\Core\Controllers\Database\Seed\Seeder;
use App\Modules\User\Models\MassEmail;
use Illuminate\Support\Facades\DB;

/**
 * Class SeedScheduledTaskTable
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class SeedScheduledTaskTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('scheduled_task')->insert([
            'name'        => 'Process mass emails',
            'description' => 'Generate and add emails to the email queue.',
            'class'       => MassEmail::class,
            'interval'    => 285,
            'last_run'    => 0,
            'running'     => 0,
            'created_at'  => time(),
            'updated_at'  => time(),
        ]);
    }
}
