<?php
/**
 * File 2016_08_23_171904_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.0.3
 */
namespace Database\Seeds\v2_0_3;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_0_3
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.0.3
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Delete force operator SSL option
        DB::table('setting')->where('name', 'force_operator_ssl')->delete();

        // Insert user organisation settings
        DB::table('setting')->insert([
            [
                'module_id'  => 2,
                'name'       => 'organisations_enabled',
                'value'      => 1,
                'created_at' => time()
            ], [
                'module_id'  => 2,
                'name'       => 'organisation_notifications',
                'value'      => 1,
                'created_at' => time()
            ]
        ]);
    }
}
