<?php
/**
 * File 2016_12_01_114000_seed_brand_table.php
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Seeds\v2_1_0;

use App\Modules\Core\Models\Brand;
use App\Modules\Ticket\Models\Department;
use App\Modules\Ticket\Models\TicketCustomField;
use App\Modules\User\Models\UserCustomField;
use App\Modules\User\Models\UserGroup;
use App\Modules\User\Models\UserOrganisationCustomField;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedBrandTable
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class SeedBrandTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Fetch brand
        $brand = Brand::first();

        // Assign all operator groups to brand
        $groups = UserGroup::operator()->get([ 'id' ])->map(function ($group, $key) use ($brand) {
            return [
                'brand_id' => $brand->id,
                'group_id' => $group->id
            ];
        });
        DB::table('brand_operator_group_membership')->insert($groups->all());

        // Assign all departments to brand
        $departments = Department::get([ 'id' ])->map(function ($department, $key) use ($brand) {
            return [
                'department_id' => $department->id,
                'brand_id'      => $brand->id,
            ];
        });
        DB::table('department_brand_membership')->insert($departments->all());

        // Assign all ticket custom fields to brand
        $fields = TicketCustomField::all([ 'id' ])->map(function ($field, $key) use ($brand) {
            return [
                'field_id' => $field->id,
                'brand_id' => $brand->id,
            ];
        });
        DB::table('ticket_customfield_brand_membership')->insert($fields->all());

        // Assign all user custom fields to brand
        $fields = UserCustomField::all([ 'id' ])->map(function ($field, $key) use ($brand) {
            return [
                'field_id' => $field->id,
                'brand_id' => $brand->id,
            ];
        });
        DB::table('user_customfield_brand_membership')->insert($fields->all());

        // Assign all user organisation custom fields to brand
        $fields = UserOrganisationCustomField::all([ 'id' ])->map(function ($field, $key) use ($brand) {
            return [
                'field_id' => $field->id,
                'brand_id' => $brand->id,
            ];
        });
        DB::table('user_organisation_customfield_brand_membership')->insert($fields->all());

        // Copy the settings to the brand table.
        $settings = [
            'base_url'          => 'system_url',
            'default_email'     => 'default_email',
            'frontend_logo'     => 'frontend_logo',
            'frontend_template' => 'frontend_template'
        ];
        foreach ($settings as $setting_name => $brand_name) {
            $setting = DB::table('setting')->where('name', 'LIKE', $setting_name)->first();
            if (isset($setting->value)) {
                $brand->$brand_name = $setting->value;
            }
        }

        $brand->save();
    }
}
