<?php
/**
 * File 2016_12_01_114001_seed_email_template_data_table.php
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Seeds\v2_1_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedEmailTemplateDataTable
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class SeedEmailTemplateDataTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Updating self-service email template article links
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'comment.article.frontend_url', 'comment.article.frontend_url(comment.type)')"
            . " WHERE `template_id` = '10' OR `template_id` = '17'"
        );
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'comment.article.frontend_url(comment.type)', 'comment.article.frontendUrl(comment.type)')"
            . " WHERE `template_id` = '10' OR `template_id` = '17'"
        );

        // Updating system merge fields to brand
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'system.company', 'brand.name')"
        );
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'system.email', 'brand.default_email')"
        );
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'system.url', 'brand.frontend_url')"
        );

        // Updating system settings merge fields to settings
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'system.waiting_response_time', 'settings.waiting_response_time')"
            . " WHERE `template_id` = '11'"
        );
        DB::update(
            "UPDATE `email_template_data`"
            . " SET `contents` = REPLACE(`contents`, 'system.inactive_close_time', 'settings.inactive_close_time')"
            . " WHERE `template_id` = '11'"
        );
    }
}
