<?php
/**
 * File 2016_12_01_114003_seed_plugin_setting_table.php
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Seeds\v2_1_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedPluginSettingTable
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class SeedPluginSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Fetch HipChat Notifications plugin
        $plugin = DB::table('plugin')->where('name', 'HipChatNotifications')->first();

        // Does it exist in database?
        if (! is_null($plugin)) {
            // Add 'brand0-' in front of the room details
            DB::table('plugin_setting')
                ->where('plugin_id', $plugin->id)
                ->where(function ($query) {
                    return $query->where('name', 'LIKE', 'room_id')
                        ->orWhere('name', 'LIKE', 'room_token');
                })
                ->update([ 'name' => DB::raw('CONCAT("brand0-", name)') ]);
        }

        // Fetch Slack Notifications plugin
        $plugin = DB::table('plugin')->where('name', 'SlackNotifications')->first();

        // Does it exist in database?
        if (! is_null($plugin)) {
            // Add 'brand0-' in front of the channel details
            DB::table('plugin_setting')
                ->where('plugin_id', $plugin->id)
                ->where(function ($query) {
                    return $query->where('name', 'LIKE', 'webhook_url')
                        ->orWhere('name', 'LIKE', 'channel');
                })
                ->update([ 'name' => DB::raw('CONCAT("brand0-", name)') ]);
        }

        // Fetch WHMCS information plugin
        $plugin = DB::table('plugin')->where('name', 'WhmcsInformation')->first();

        // Does it exist in database?
        if (! is_null($plugin)) {
            // Add 'brand0-' in front of the connection settings
            DB::table('plugin_setting')
                ->where('plugin_id', $plugin->id)
                ->where('name', 'NOT LIKE', 'product_info')
                ->where('name', 'NOT LIKE', 'user_sync')
                ->update([ 'name' => DB::raw('CONCAT("brand0-", name)') ]);
        }
    }
}
