<?php
/**
 * File 2016_12_01_114004_seed_setting_table.php
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.0
 */
namespace Database\Seeds\v2_1_0;

use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedSettingTable
 *
 * @package    Database\Seeds\v2_1_0
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.0
 */
class SeedSettingTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $time = time();

        // Fetch default open status
        $status = DB::table('setting')->where('name', 'default_open_status')->first()->value;

        // Insert default reply status
        DB::table('setting')->insert([
            [
                'module_id'  => 1,
                'name'       => 'default_brand',
                'value'      => 1,
                'created_at' => $time
            ], [
                'module_id'  => 3,
                'name'       => 'default_reply_status',
                'value'      => $status,
                'created_at' => $time
            ]
        ]);

        // Removing settings that are no longer used, some of these were removed before 2.1.0
        DB::table('setting')
            ->where('name', 'LIKE', 'active_plugins')
            ->orWhere('name', 'LIKE', 'base_url')
            ->orWhere('name', 'LIKE', 'company_name')
            ->orWhere('name', 'LIKE', 'default_email')
            ->orWhere('name', 'LIKE', 'force_operator_ssl')
            ->orWhere('name', 'LIKE', 'frontend_logo')
            ->orWhere('name', 'LIKE', 'frontend_template')
            ->delete();
    }
}
