<?php
/**
 * File 2017_01_14_183310_seed_channel_account_info_table.php
 *
 * @package    Database\Seeds\v2_1_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @since      File available since Release 2.1.1
 */
namespace Database\Seeds\v2_1_1;

use App\Modules\Ticket\Models\ChannelAccount;
use App\Modules\Ticket\Models\ChannelAccountInfo;
use Crypt;
use DB;
use App\Modules\Core\Controllers\Database\Seed\Seeder;

/**
 * Class SeedChannelAccountInfoTable
 *
 * @package    Database\Seeds\v2_1_1
 * @copyright  Copyright (c) 2015-2016 SupportPal (http://www.supportpal.com)
 * @license    http://www.supportpal.com/company/eula
 * @version    Release: @package_version@
 * @since      Class available since Release 2.1.1
 */
class SeedChannelAccountInfoTable extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $accounts = ChannelAccount::with('channel.settings', 'info')->get();

        foreach ($accounts as $account) {
            // Encrypt necessary details for Facebook and Twitter
            if ($account->channel->name == 'Facebook') {
                $account->info->each(function ($item, $key) {
                    if ($item->name == 'app_secret' || $item->name == 'access_token') {
                        $item->value = Crypt::encrypt($item->value);
                        $item->save();
                    }
                });
            } elseif ($account->channel->name == 'Twitter') {
                $account->info->each(function ($item, $key) {
                    if ($item->name == 'consumer_secret' || $item->name == 'access_token'
                        || $item->name == 'access_token_secret'
                    ) {
                        $item->value = Crypt::encrypt($item->value);
                        $item->save();
                    }
                });
            }

            // Save the default department and priority per account too
            $defaultDepartment = $account->channel->settings->where('name', 'default_department')->first();
            if (! empty($defaultDepartment)) {
                ChannelAccountInfo::addInfo($account->id, 'department_id', $defaultDepartment->value);
            }
            $defaultPriority = $account->channel->settings->where('name', 'default_priority')->first();
            if (! empty($defaultPriority)) {
                ChannelAccountInfo::addInfo($account->id, 'priority_id', $defaultPriority->value);
            }
        }

        // Delete existing default settings
        DB::table('ticket_channel_setting')
            ->where('name', 'LIKE', 'default_department')
            ->where('name', 'LIKE', 'default_priority')
            ->delete();
    }
}
